<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/Slider.php";
    
    if(isset($_GET["id"])) {
        $slider = new Slider($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $slider->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione slider</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	  

    <main role="main" class="bg-light" id="main">
        <div class="container-fluid">
            <div class="row py-4">
                <?php 
                    if($status==200) {
                        echo"<div class=\"col-12\">
                                <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                    Slider creato
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                          <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                </div>
                            </div>";
                    }

                    if($status==250) {
                        echo"<div class=\"col-12\">
                                <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                    Slider modificato
                                    <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                          <span aria-hidden=\"true\">&times;</span>
                                    </button>
                                </div>
                            </div>";
                    }
                ?>
                <div class="col-12">
                    <div class="form-row justify-content-between mb-3">
                        <div class="col-auto d-flex">
                            <nav aria-label="breadcrumb" class="align-self-center">
                                <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                    <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                    <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                    <li class="breadcrumb-item"><a href="index.php">Slider</a></li>
                                    <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($slider)? $slider->getNome() : "Nuovo slider"))?></li>
                                </ol>
                            </nav>
                        </div>
                        <div class="col-auto text-right">
                            <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                            <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                    <div class="card mb-4 box-shadow-lite">
                        <form name="formComponente" action="controller/controllerComponente.php" method="post">
                            <input type="text" class="d-none" name="operazione" value="<?php echo((isset($slider) ? "modifica" : "crea")); ?>">
                            <input type="text" class="d-none" name="id" value="<?php echo((isset($slider) ? $slider->getId() : "0")); ?>">
                            
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6 form-group">
                                        <label>Nome</label>
                                        <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($slider) ? $slider->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                    </div>
                                    
                                    <div class="w-100"></div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label for="inputPassword3" >Spazio occupato</label>
                                        <select class="form-control" name="spazioOccupato">
                                        <?php 
                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                if(isset($slider) && $slider->getSpazioOccupato()==$classe) {
                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                        <small class="text-muted">Scegli lo spazio che deve occupare la tua form nella sezione</small>
                                    </div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label for="">Altezza proporzionale</label>
                                        <select class="form-control" name="altezza">
                                            <?php 
                                                foreach($arrayAltezze as $classe=>$descrizione) {
                                                    if(isset($slider) && $slider->getAltezza()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Stabilisce l'altezza proporzionale occupata dallo slider rispetto alla viewport</small>
                                    </div>
                                    <?php 
                                        $transizione = array("none","slideInRight","fadeIn","fadeInDown","flipInX","flipInY","zoomIn");
                                    ?>
                                    <div class="col-md-3 form-group">
                                        <label for="">Transizione fra le slide</label>
                                        <select class="form-control" name="tipoTransizione">
                                            <?php 
                                                foreach($transizione as $tipo) {
                                                    if(isset($slider) && $slider->getTipoTransizione()==$tipo) {
                                                        echo"<option value=\"$tipo\" selected>$tipo</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$tipo\">$tipo</option>";
                                                    }
                                                }
                                            ?>
                                        </select>
                                        <small class="form-text text-muted">Stabilisce il tipo di transizione fra una slide e l'altra</small>
                                    </div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label for="">Tempo permanenza singola slide</label>
                                        <input type="number" class="form-control" name="tempoPermanenzaSingolaSlide" min="1" value="<?php echo((isset($slider)) ? $slider->getTempoPermanenzaSingolaSlide() : "1") ?>">
                                        <small class="form-text text-muted">Tempo di permanenza in millisecondi di ogni singola slide</small>
                                    </div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label class="d-block">Mostra frecce</label>
                                        <input type="checkbox" name="mostraFreccette" class="js-switch" <?php echo((isset($slider) && $slider->getMostraFreccette()=="si") ? "checked" : "1") ?> value="si">
                                    </div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label class="d-block">Mostra punti navigazione</label>
                                        <input type="checkbox" name="mostraPuntiNavigazione" class="js-switch" <?php echo((isset($slider) && $slider->getMostraPuntiNavigazione()=="si") ? "checked" : "1") ?> value="si">
                                    </div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label class="d-block">Autoplay</label>
                                        <input type="checkbox" name="autoplay" class="js-switch" <?php echo((isset($slider) && $slider->getAutoplay()=="si") ? "checked" : "1") ?> value="si">
                                    </div>
                                    
                                    <div class="col-md-3 form-group">
                                        <label class="d-block">Pausa on hover</label>
                                        <input type="checkbox" name="pausaOnHover" class="js-switch" <?php echo((isset($slider) && $slider->getPausaOnHover()=="si") ? "checked" : "1") ?> value="si">
                                    </div>
                                    
                                    <hr class="w-100">
                                    <div class="col-md-3 form-group">
                                        <label for="">Slide su smartphone</label>
                                        <input type="number" class="form-control" name="slideMostrateSuSmartphone" min="1" value="<?php echo((isset($slider)) ? $slider->getSlideMostrateSuSmartphone() : "1") ?>">
                                        <small class="form-text text-muted">Il numero di slide che appariranno contemporanemente quando lo slider ha una risoluzione orizzontale minore di 600 px</small>
                                    </div>
                                    <div class="col-md-3 form-group">
                                        <label for="">Slide su tablet</label>
                                        <input type="number" class="form-control" name="slideMostrateSuTablet" min="1" value="<?php echo((isset($slider)) ? $slider->getSlideMostrateSuTablet() : "1") ?>">
                                        <small class="form-text text-muted">Il numero di slide che appariranno contemporanemente quando lo slider ha una risoluzione orizzontale compresa fra 600 e 999 px</small>
                                    </div>
                                    <div class="col-md-3 form-group">
                                        <label for="">Slide su desktop</label>
                                        <input type="number" class="form-control" name="slideMostrateSuDesktop" min="1" value="<?php echo((isset($slider)) ? $slider->getSlideMostrateSuDesktop() : "1") ?>">
                                        <small class="form-text text-muted">Il numero di slide che appariranno contemporanemente  quando lo slider ha una risoluzione orizzontale compresa fra 1000 e 1599 px</small>
                                    </div>
                                    <div class="col-md-3 form-group">
                                        <label for="">Slide su grandi schermi</label>
                                        <input type="number" class="form-control" name="slideMostrateSuLargeDesktop" min="1" value="<?php echo((isset($slider)) ? $slider->getSlideMostrateSuLargeDesktop() : "1") ?>">
                                        <small class="form-text text-muted">Il numero di slide che appariranno contemporanemente  quando lo slider ha una risoluzione orizzontale maggiore o uguale a 1600 px</small>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <div class="card-footer">
                            <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                    <div class="card mb-4 box-shadow-lite">
                        <?php 
                            if(isset($slider)) {
                        ?>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-4 col-xl-3 align-self-start sticky-top">
                                    <form>
                                        <div class="mb-4 add-box">
                                            <h5 class="mb-3"> Aggiungi una slide </h5>
                                            <div class="options-box">
                                                <div class="form-group">
                                                    <label>Nome</label>
                                                    <input type="text" class="form-control" id="nomeElemento" placeholder="Nome">
                                                </div>

                                                <div class="form-group">
                                                    <label>Link</label>
                                                    <input type="text" class="form-control" id="linkElemento"  placeholder="Link">
                                                </div>
                                                
                                                <button type="button" class="btn btn-primary float-right" value="Crea" onclick="creaElemento()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>

                                <div id="divElencoElementi" class="col-lg-8 col-xl-9 mb-4 gerarchia-menu">
                                    <?php 
                                        $slider->stampaElementi();
                                    ?>
                                </div>
                            </div>
                        </div>
                        <?php
                            }        
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <?php 
        include "../../include/footer.php";
        
        include "../include/modal/eliminaElemento.php";
        
        include "../include/modal/cambiaPassword.php";
                
        include "../../include/modal/modalMenuComponenti.php";
        
        include "../../include/modal/operazioneCompletata.php";
    
        include "../include/jsBaseComponenti.php";
    ?>

        <script>
            
            function eliminaElemento(id,nomeElemento,tipoElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneElemento() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaElemento",
                        id:<?php echo $slider->getId() ?>,
                        idElemento:id
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            document.getElementById("elementoComponente"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function spostaElementoInput(id) {
                var posizione = $('#nuovaPosizioneElemento'+id).val();
                spostaElemento(id,posizione);
            }
            
            function spostaElemento(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"spostaElemento",
                        id:<?php echo $slider->getId() ?>,
                        idElemento:id,
                        posizione:posizione
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert(esito);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function creaElemento() {
                var nome = $('#nomeElemento').val();
                var link = $('#linkElemento').val();
                
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"creaElemento",
                        id:<?php echo $slider->getId() ?>,
                        nome:nome,
                        link:link
                    },
                    success:function(esito) {
                        if(esito=="ok") {
                            aggiornaDivElementi();
                        }
                        else {
                            alert("Si è verificato un errore, contatta l'amministratore del sito")
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaDivElementi() {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"stampaElementi",
                        id:<?php echo $slider->getId() ?>
                    },
                    success:function(result) {
                        document.getElementById("divElencoElementi").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
  </body>
</html>
